# VP Get row attributes

<!-- REF #_method_.VP Get row attributes.Syntax -->
**VP Get row attributes** ( rangeObj : Object ) : Collection<!-- END REF -->

<!-- REF #_method_.VP Get row attributes.Params -->

|Parameter|Type| |Description|
|---|---|---|---|
|rangeObj  |Object|->|Range object|
|Result  |Collection|<-|Collection of row properties|<!-- END REF -->

## Description

The `VP Get row attributes` command <!-- REF #_method_.VP Get row attributes.Summary -->returns a collection of properties for any row in the *rangeObj*<!-- END REF -->.

In *rangeObj*, pass an object containing a range of the rows whose attributes will be retrieved.

The returned collection contains any properties for the rows, whether or not they have been set by the [VP SET ROW ATTRIBUTES](VP%20SET%20ROW%20ATTRIBUTES.md) method.

## Example

The following code returns a collection of the attributes within the given range:

```4d
var $range : Object
var $attr : Collection
 
$range:=VP Column("ViewProArea";1;2)
$attr:=VP Get row attributes($range)
```

![](../images/cmd_vpGetRowAttributes.PNG)

## See also

[VP Get column attributes](VP%20Get%20column%20attributes.md)<br/>
[VP SET COLUMN ATTRIBUTES](VP%20SET%20COLUMN%20ATTRIBUTES.md)<br/>
[VP SET ROW ATTRIBUTES](VP%20SET%20ROW%20ATTRIBUTES.md)